;++
;
; Copyright (c) Microsoft Corporation. All rights reserved. 
;
; You may only use this code if you agree to the terms of the Windows Research Kernel Source Code License agreement (see License.txt).
; If you do not agree to the terms, do not use the code.
;
; Module Name:
;
;    sysstubs.asm
;
; Abstract:
;
;    This module implements the system service dispatch stub procedures.
;
; Revision History:
;       Use Fast System call mechanism.
;
;--

include ks386.inc
include callconv.inc

.386

STUBS_BEGIN1 macro t
    TITLE t
endm
STUBS_BEGIN2 macro t
endm
STUBS_BEGIN3 macro t
_TEXT	SEGMENT DWORD PUBLIC 'CODE'
        ASSUME  DS:FLAT, ES:FLAT, SS:NOTHING, FS:NOTHING, GS:NOTHING
endm
STUBS_BEGIN4 macro t
endm
STUBS_BEGIN5 macro t
    align 4
endm
STUBS_BEGIN6 macro t
endm
STUBS_BEGIN7 macro t
endm
STUBS_BEGIN8 macro t
endm

STUBS_END    macro t
_TEXT ENDS
      end
endm

SYSSTUBS_ENTRY1 macro ServiceNumber, Name, NumArgs
cPublicProc _Zw&Name,NumArgs
.FPO ( 0, NumArgs, 0, 0, 0, 0 )
        extrn   _KiSystemService:PROC
        mov     eax, ServiceNumber      ; (eax) = service number
        lea     edx, [esp]+4            ; (edx) -> arguments
        pushfd                          ; EFLAGS to trap frame
        push    KGDT_R0_CODE            ; CS to trap frame
        call    _KiSystemService        ; EIP to trap frame and enter handler
        stdRET  _Zw&Name
stdENDP _Zw&Name
endm

SYSSTUBS_ENTRY2 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY3 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY4 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY5 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY6 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY7 macro ServiceNumber, Name, NumArgs
endm
SYSSTUBS_ENTRY8 macro ServiceNumber, Name, NumArgs
endm


USRSTUBS_ENTRY1 macro ServiceNumber, Name, NumArgs
cPublicProc     _Zw&Name, NumArgs
PUBLICP _Nt&Name, NumArgs
LABELP  _Nt&Name, NumArgs
.FPO ( 0, NumArgs, 0, 0, 0, 0 )
        mov     eax, ServiceNumber      ; (eax) = service number
        mov     edx, MM_SHARED_USER_DATA_VA+UsSystemCall
        call    [edx]
        stdRET  _Zw&Name
stdENDP _Zw&Name
endm

USRSTUBS_ENTRY2 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY3 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY4 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY5 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY6 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY7 macro ServiceNumber, Name, NumArgs
endm
USRSTUBS_ENTRY8 macro ServiceNumber, Name, NumArgs
endm

        STUBS_BEGIN1 <"System Service Stub Procedures">
        STUBS_BEGIN2 <"System Service Stub Procedures">
        STUBS_BEGIN3 <"System Service Stub Procedures">
        STUBS_BEGIN4 <"System Service Stub Procedures">
        STUBS_BEGIN5 <"System Service Stub Procedures">
        STUBS_BEGIN6 <"System Service Stub Procedures">
        STUBS_BEGIN7 <"System Service Stub Procedures">
        STUBS_BEGIN8 <"System Service Stub Procedures">
SYSSTUBS_ENTRY1  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY2  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY3  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY4  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY5  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY6  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY7  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY8  0, AcceptConnectPort, 6 
SYSSTUBS_ENTRY1  1, AccessCheck, 8 
SYSSTUBS_ENTRY2  1, AccessCheck, 8 
SYSSTUBS_ENTRY3  1, AccessCheck, 8 
SYSSTUBS_ENTRY4  1, AccessCheck, 8 
SYSSTUBS_ENTRY5  1, AccessCheck, 8 
SYSSTUBS_ENTRY6  1, AccessCheck, 8 
SYSSTUBS_ENTRY7  1, AccessCheck, 8 
SYSSTUBS_ENTRY8  1, AccessCheck, 8 
SYSSTUBS_ENTRY1  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY2  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY3  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY4  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY5  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY6  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY7  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY8  2, AccessCheckAndAuditAlarm, 11 
SYSSTUBS_ENTRY1  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY2  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY3  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY4  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY5  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY6  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY7  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY8  3, AccessCheckByType, 11 
SYSSTUBS_ENTRY1  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY2  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY3  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY4  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY5  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY6  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY7  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY8  4, AccessCheckByTypeAndAuditAlarm, 16 
SYSSTUBS_ENTRY1  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY2  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY3  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY4  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY5  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY6  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY7  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY8  5, AccessCheckByTypeResultList, 11 
SYSSTUBS_ENTRY1  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY2  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY3  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY4  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY5  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY6  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY7  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY8  6, AccessCheckByTypeResultListAndAuditAlarm, 16 
SYSSTUBS_ENTRY1  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY2  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY3  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY4  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY5  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY6  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY7  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY8  7, AccessCheckByTypeResultListAndAuditAlarmByHandle, 17 
SYSSTUBS_ENTRY1  8, AddAtom, 3 
SYSSTUBS_ENTRY2  8, AddAtom, 3 
SYSSTUBS_ENTRY3  8, AddAtom, 3 
SYSSTUBS_ENTRY4  8, AddAtom, 3 
SYSSTUBS_ENTRY5  8, AddAtom, 3 
SYSSTUBS_ENTRY6  8, AddAtom, 3 
SYSSTUBS_ENTRY7  8, AddAtom, 3 
SYSSTUBS_ENTRY8  8, AddAtom, 3 
SYSSTUBS_ENTRY1  9, AddBootEntry, 2 
SYSSTUBS_ENTRY2  9, AddBootEntry, 2 
SYSSTUBS_ENTRY3  9, AddBootEntry, 2 
SYSSTUBS_ENTRY4  9, AddBootEntry, 2 
SYSSTUBS_ENTRY5  9, AddBootEntry, 2 
SYSSTUBS_ENTRY6  9, AddBootEntry, 2 
SYSSTUBS_ENTRY7  9, AddBootEntry, 2 
SYSSTUBS_ENTRY8  9, AddBootEntry, 2 
SYSSTUBS_ENTRY1  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY2  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY3  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY4  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY5  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY6  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY7  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY8  10, AddDriverEntry, 2 
SYSSTUBS_ENTRY1  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY2  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY3  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY4  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY5  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY6  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY7  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY8  11, AdjustGroupsToken, 6 
SYSSTUBS_ENTRY1  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY2  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY3  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY4  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY5  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY6  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY7  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY8  12, AdjustPrivilegesToken, 6 
SYSSTUBS_ENTRY1  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY2  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY3  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY4  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY5  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY6  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY7  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY8  13, AlertResumeThread, 2 
SYSSTUBS_ENTRY1  14, AlertThread, 1 
SYSSTUBS_ENTRY2  14, AlertThread, 1 
SYSSTUBS_ENTRY3  14, AlertThread, 1 
SYSSTUBS_ENTRY4  14, AlertThread, 1 
SYSSTUBS_ENTRY5  14, AlertThread, 1 
SYSSTUBS_ENTRY6  14, AlertThread, 1 
SYSSTUBS_ENTRY7  14, AlertThread, 1 
SYSSTUBS_ENTRY8  14, AlertThread, 1 
SYSSTUBS_ENTRY1  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY2  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY3  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY4  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY5  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY6  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY7  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY8  15, AllocateLocallyUniqueId, 1 
SYSSTUBS_ENTRY1  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY2  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY3  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY4  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY5  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY6  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY7  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY8  16, AllocateUserPhysicalPages, 3 
SYSSTUBS_ENTRY1  17, AllocateUuids, 4 
SYSSTUBS_ENTRY2  17, AllocateUuids, 4 
SYSSTUBS_ENTRY3  17, AllocateUuids, 4 
SYSSTUBS_ENTRY4  17, AllocateUuids, 4 
SYSSTUBS_ENTRY5  17, AllocateUuids, 4 
SYSSTUBS_ENTRY6  17, AllocateUuids, 4 
SYSSTUBS_ENTRY7  17, AllocateUuids, 4 
SYSSTUBS_ENTRY8  17, AllocateUuids, 4 
SYSSTUBS_ENTRY1  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY2  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY3  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY4  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY5  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY6  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY7  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY8  18, AllocateVirtualMemory, 6 
SYSSTUBS_ENTRY1  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY2  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY3  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY4  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY5  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY6  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY7  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY8  19, ApphelpCacheControl, 2 
SYSSTUBS_ENTRY1  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY2  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY3  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY4  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY5  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY6  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY7  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY8  20, AreMappedFilesTheSame, 2 
SYSSTUBS_ENTRY1  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY2  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY3  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY4  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY5  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY6  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY7  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY8  21, AssignProcessToJobObject, 2 
SYSSTUBS_ENTRY1  22, CallbackReturn, 3 
SYSSTUBS_ENTRY2  22, CallbackReturn, 3 
SYSSTUBS_ENTRY3  22, CallbackReturn, 3 
SYSSTUBS_ENTRY4  22, CallbackReturn, 3 
SYSSTUBS_ENTRY5  22, CallbackReturn, 3 
SYSSTUBS_ENTRY6  22, CallbackReturn, 3 
SYSSTUBS_ENTRY7  22, CallbackReturn, 3 
SYSSTUBS_ENTRY8  22, CallbackReturn, 3 
SYSSTUBS_ENTRY1  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY2  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY3  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY4  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY5  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY6  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY7  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY8  23, CancelDeviceWakeupRequest, 1 
SYSSTUBS_ENTRY1  24, CancelIoFile, 2 
SYSSTUBS_ENTRY2  24, CancelIoFile, 2 
SYSSTUBS_ENTRY3  24, CancelIoFile, 2 
SYSSTUBS_ENTRY4  24, CancelIoFile, 2 
SYSSTUBS_ENTRY5  24, CancelIoFile, 2 
SYSSTUBS_ENTRY6  24, CancelIoFile, 2 
SYSSTUBS_ENTRY7  24, CancelIoFile, 2 
SYSSTUBS_ENTRY8  24, CancelIoFile, 2 
SYSSTUBS_ENTRY1  25, CancelTimer, 2 
SYSSTUBS_ENTRY2  25, CancelTimer, 2 
SYSSTUBS_ENTRY3  25, CancelTimer, 2 
SYSSTUBS_ENTRY4  25, CancelTimer, 2 
SYSSTUBS_ENTRY5  25, CancelTimer, 2 
SYSSTUBS_ENTRY6  25, CancelTimer, 2 
SYSSTUBS_ENTRY7  25, CancelTimer, 2 
SYSSTUBS_ENTRY8  25, CancelTimer, 2 
SYSSTUBS_ENTRY1  26, ClearEvent, 1 
SYSSTUBS_ENTRY2  26, ClearEvent, 1 
SYSSTUBS_ENTRY3  26, ClearEvent, 1 
SYSSTUBS_ENTRY4  26, ClearEvent, 1 
SYSSTUBS_ENTRY5  26, ClearEvent, 1 
SYSSTUBS_ENTRY6  26, ClearEvent, 1 
SYSSTUBS_ENTRY7  26, ClearEvent, 1 
SYSSTUBS_ENTRY8  26, ClearEvent, 1 
SYSSTUBS_ENTRY1  27, Close, 1 
SYSSTUBS_ENTRY2  27, Close, 1 
SYSSTUBS_ENTRY3  27, Close, 1 
SYSSTUBS_ENTRY4  27, Close, 1 
SYSSTUBS_ENTRY5  27, Close, 1 
SYSSTUBS_ENTRY6  27, Close, 1 
SYSSTUBS_ENTRY7  27, Close, 1 
SYSSTUBS_ENTRY8  27, Close, 1 
SYSSTUBS_ENTRY1  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY2  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY3  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY4  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY5  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY6  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY7  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY8  28, CloseObjectAuditAlarm, 3 
SYSSTUBS_ENTRY1  29, CompactKeys, 2 
SYSSTUBS_ENTRY2  29, CompactKeys, 2 
SYSSTUBS_ENTRY3  29, CompactKeys, 2 
SYSSTUBS_ENTRY4  29, CompactKeys, 2 
SYSSTUBS_ENTRY5  29, CompactKeys, 2 
SYSSTUBS_ENTRY6  29, CompactKeys, 2 
SYSSTUBS_ENTRY7  29, CompactKeys, 2 
SYSSTUBS_ENTRY8  29, CompactKeys, 2 
SYSSTUBS_ENTRY1  30, CompareTokens, 3 
SYSSTUBS_ENTRY2  30, CompareTokens, 3 
SYSSTUBS_ENTRY3  30, CompareTokens, 3 
SYSSTUBS_ENTRY4  30, CompareTokens, 3 
SYSSTUBS_ENTRY5  30, CompareTokens, 3 
SYSSTUBS_ENTRY6  30, CompareTokens, 3 
SYSSTUBS_ENTRY7  30, CompareTokens, 3 
SYSSTUBS_ENTRY8  30, CompareTokens, 3 
SYSSTUBS_ENTRY1  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY2  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY3  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY4  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY5  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY6  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY7  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY8  31, CompleteConnectPort, 1 
SYSSTUBS_ENTRY1  32, CompressKey, 1 
SYSSTUBS_ENTRY2  32, CompressKey, 1 
SYSSTUBS_ENTRY3  32, CompressKey, 1 
SYSSTUBS_ENTRY4  32, CompressKey, 1 
SYSSTUBS_ENTRY5  32, CompressKey, 1 
SYSSTUBS_ENTRY6  32, CompressKey, 1 
SYSSTUBS_ENTRY7  32, CompressKey, 1 
SYSSTUBS_ENTRY8  32, CompressKey, 1 
SYSSTUBS_ENTRY1  33, ConnectPort, 8 
SYSSTUBS_ENTRY2  33, ConnectPort, 8 
SYSSTUBS_ENTRY3  33, ConnectPort, 8 
SYSSTUBS_ENTRY4  33, ConnectPort, 8 
SYSSTUBS_ENTRY5  33, ConnectPort, 8 
SYSSTUBS_ENTRY6  33, ConnectPort, 8 
SYSSTUBS_ENTRY7  33, ConnectPort, 8 
SYSSTUBS_ENTRY8  33, ConnectPort, 8 
SYSSTUBS_ENTRY1  34, Continue, 2 
SYSSTUBS_ENTRY2  34, Continue, 2 
SYSSTUBS_ENTRY3  34, Continue, 2 
SYSSTUBS_ENTRY4  34, Continue, 2 
SYSSTUBS_ENTRY5  34, Continue, 2 
SYSSTUBS_ENTRY6  34, Continue, 2 
SYSSTUBS_ENTRY7  34, Continue, 2 
SYSSTUBS_ENTRY8  34, Continue, 2 
SYSSTUBS_ENTRY1  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY2  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY3  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY4  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY5  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY6  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY7  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY8  35, CreateDebugObject, 4 
SYSSTUBS_ENTRY1  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY2  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY3  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY4  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY5  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY6  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY7  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY8  36, CreateDirectoryObject, 3 
SYSSTUBS_ENTRY1  37, CreateEvent, 5 
SYSSTUBS_ENTRY2  37, CreateEvent, 5 
SYSSTUBS_ENTRY3  37, CreateEvent, 5 
SYSSTUBS_ENTRY4  37, CreateEvent, 5 
SYSSTUBS_ENTRY5  37, CreateEvent, 5 
SYSSTUBS_ENTRY6  37, CreateEvent, 5 
SYSSTUBS_ENTRY7  37, CreateEvent, 5 
SYSSTUBS_ENTRY8  37, CreateEvent, 5 
SYSSTUBS_ENTRY1  38, CreateEventPair, 3 
SYSSTUBS_ENTRY2  38, CreateEventPair, 3 
SYSSTUBS_ENTRY3  38, CreateEventPair, 3 
SYSSTUBS_ENTRY4  38, CreateEventPair, 3 
SYSSTUBS_ENTRY5  38, CreateEventPair, 3 
SYSSTUBS_ENTRY6  38, CreateEventPair, 3 
SYSSTUBS_ENTRY7  38, CreateEventPair, 3 
SYSSTUBS_ENTRY8  38, CreateEventPair, 3 
SYSSTUBS_ENTRY1  39, CreateFile, 11 
SYSSTUBS_ENTRY2  39, CreateFile, 11 
SYSSTUBS_ENTRY3  39, CreateFile, 11 
SYSSTUBS_ENTRY4  39, CreateFile, 11 
SYSSTUBS_ENTRY5  39, CreateFile, 11 
SYSSTUBS_ENTRY6  39, CreateFile, 11 
SYSSTUBS_ENTRY7  39, CreateFile, 11 
SYSSTUBS_ENTRY8  39, CreateFile, 11 
SYSSTUBS_ENTRY1  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY2  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY3  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY4  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY5  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY6  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY7  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY8  40, CreateIoCompletion, 4 
SYSSTUBS_ENTRY1  41, CreateJobObject, 3 
SYSSTUBS_ENTRY2  41, CreateJobObject, 3 
SYSSTUBS_ENTRY3  41, CreateJobObject, 3 
SYSSTUBS_ENTRY4  41, CreateJobObject, 3 
SYSSTUBS_ENTRY5  41, CreateJobObject, 3 
SYSSTUBS_ENTRY6  41, CreateJobObject, 3 
SYSSTUBS_ENTRY7  41, CreateJobObject, 3 
SYSSTUBS_ENTRY8  41, CreateJobObject, 3 
SYSSTUBS_ENTRY1  42, CreateJobSet, 3 
SYSSTUBS_ENTRY2  42, CreateJobSet, 3 
SYSSTUBS_ENTRY3  42, CreateJobSet, 3 
SYSSTUBS_ENTRY4  42, CreateJobSet, 3 
SYSSTUBS_ENTRY5  42, CreateJobSet, 3 
SYSSTUBS_ENTRY6  42, CreateJobSet, 3 
SYSSTUBS_ENTRY7  42, CreateJobSet, 3 
SYSSTUBS_ENTRY8  42, CreateJobSet, 3 
SYSSTUBS_ENTRY1  43, CreateKey, 7 
SYSSTUBS_ENTRY2  43, CreateKey, 7 
SYSSTUBS_ENTRY3  43, CreateKey, 7 
SYSSTUBS_ENTRY4  43, CreateKey, 7 
SYSSTUBS_ENTRY5  43, CreateKey, 7 
SYSSTUBS_ENTRY6  43, CreateKey, 7 
SYSSTUBS_ENTRY7  43, CreateKey, 7 
SYSSTUBS_ENTRY8  43, CreateKey, 7 
SYSSTUBS_ENTRY1  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY2  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY3  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY4  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY5  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY6  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY7  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY8  44, CreateMailslotFile, 8 
SYSSTUBS_ENTRY1  45, CreateMutant, 4 
SYSSTUBS_ENTRY2  45, CreateMutant, 4 
SYSSTUBS_ENTRY3  45, CreateMutant, 4 
SYSSTUBS_ENTRY4  45, CreateMutant, 4 
SYSSTUBS_ENTRY5  45, CreateMutant, 4 
SYSSTUBS_ENTRY6  45, CreateMutant, 4 
SYSSTUBS_ENTRY7  45, CreateMutant, 4 
SYSSTUBS_ENTRY8  45, CreateMutant, 4 
SYSSTUBS_ENTRY1  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY2  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY3  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY4  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY5  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY6  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY7  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY8  46, CreateNamedPipeFile, 14 
SYSSTUBS_ENTRY1  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY2  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY3  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY4  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY5  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY6  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY7  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY8  47, CreatePagingFile, 4 
SYSSTUBS_ENTRY1  48, CreatePort, 5 
SYSSTUBS_ENTRY2  48, CreatePort, 5 
SYSSTUBS_ENTRY3  48, CreatePort, 5 
SYSSTUBS_ENTRY4  48, CreatePort, 5 
SYSSTUBS_ENTRY5  48, CreatePort, 5 
SYSSTUBS_ENTRY6  48, CreatePort, 5 
SYSSTUBS_ENTRY7  48, CreatePort, 5 
SYSSTUBS_ENTRY8  48, CreatePort, 5 
SYSSTUBS_ENTRY1  49, CreateProcess, 8 
SYSSTUBS_ENTRY2  49, CreateProcess, 8 
SYSSTUBS_ENTRY3  49, CreateProcess, 8 
SYSSTUBS_ENTRY4  49, CreateProcess, 8 
SYSSTUBS_ENTRY5  49, CreateProcess, 8 
SYSSTUBS_ENTRY6  49, CreateProcess, 8 
SYSSTUBS_ENTRY7  49, CreateProcess, 8 
SYSSTUBS_ENTRY8  49, CreateProcess, 8 
SYSSTUBS_ENTRY1  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY2  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY3  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY4  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY5  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY6  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY7  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY8  50, CreateProcessEx, 9 
SYSSTUBS_ENTRY1  51, CreateProfile, 9 
SYSSTUBS_ENTRY2  51, CreateProfile, 9 
SYSSTUBS_ENTRY3  51, CreateProfile, 9 
SYSSTUBS_ENTRY4  51, CreateProfile, 9 
SYSSTUBS_ENTRY5  51, CreateProfile, 9 
SYSSTUBS_ENTRY6  51, CreateProfile, 9 
SYSSTUBS_ENTRY7  51, CreateProfile, 9 
SYSSTUBS_ENTRY8  51, CreateProfile, 9 
SYSSTUBS_ENTRY1  52, CreateSection, 7 
SYSSTUBS_ENTRY2  52, CreateSection, 7 
SYSSTUBS_ENTRY3  52, CreateSection, 7 
SYSSTUBS_ENTRY4  52, CreateSection, 7 
SYSSTUBS_ENTRY5  52, CreateSection, 7 
SYSSTUBS_ENTRY6  52, CreateSection, 7 
SYSSTUBS_ENTRY7  52, CreateSection, 7 
SYSSTUBS_ENTRY8  52, CreateSection, 7 
SYSSTUBS_ENTRY1  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY2  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY3  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY4  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY5  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY6  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY7  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY8  53, CreateSemaphore, 5 
SYSSTUBS_ENTRY1  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY2  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY3  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY4  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY5  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY6  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY7  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY8  54, CreateSymbolicLinkObject, 4 
SYSSTUBS_ENTRY1  55, CreateThread, 8 
SYSSTUBS_ENTRY2  55, CreateThread, 8 
SYSSTUBS_ENTRY3  55, CreateThread, 8 
SYSSTUBS_ENTRY4  55, CreateThread, 8 
SYSSTUBS_ENTRY5  55, CreateThread, 8 
SYSSTUBS_ENTRY6  55, CreateThread, 8 
SYSSTUBS_ENTRY7  55, CreateThread, 8 
SYSSTUBS_ENTRY8  55, CreateThread, 8 
SYSSTUBS_ENTRY1  56, CreateTimer, 4 
SYSSTUBS_ENTRY2  56, CreateTimer, 4 
SYSSTUBS_ENTRY3  56, CreateTimer, 4 
SYSSTUBS_ENTRY4  56, CreateTimer, 4 
SYSSTUBS_ENTRY5  56, CreateTimer, 4 
SYSSTUBS_ENTRY6  56, CreateTimer, 4 
SYSSTUBS_ENTRY7  56, CreateTimer, 4 
SYSSTUBS_ENTRY8  56, CreateTimer, 4 
SYSSTUBS_ENTRY1  57, CreateToken, 13 
SYSSTUBS_ENTRY2  57, CreateToken, 13 
SYSSTUBS_ENTRY3  57, CreateToken, 13 
SYSSTUBS_ENTRY4  57, CreateToken, 13 
SYSSTUBS_ENTRY5  57, CreateToken, 13 
SYSSTUBS_ENTRY6  57, CreateToken, 13 
SYSSTUBS_ENTRY7  57, CreateToken, 13 
SYSSTUBS_ENTRY8  57, CreateToken, 13 
SYSSTUBS_ENTRY1  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY2  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY3  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY4  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY5  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY6  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY7  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY8  58, CreateWaitablePort, 5 
SYSSTUBS_ENTRY1  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY2  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY3  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY4  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY5  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY6  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY7  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY8  59, DebugActiveProcess, 2 
SYSSTUBS_ENTRY1  60, DebugContinue, 3 
SYSSTUBS_ENTRY2  60, DebugContinue, 3 
SYSSTUBS_ENTRY3  60, DebugContinue, 3 
SYSSTUBS_ENTRY4  60, DebugContinue, 3 
SYSSTUBS_ENTRY5  60, DebugContinue, 3 
SYSSTUBS_ENTRY6  60, DebugContinue, 3 
SYSSTUBS_ENTRY7  60, DebugContinue, 3 
SYSSTUBS_ENTRY8  60, DebugContinue, 3 
SYSSTUBS_ENTRY1  61, DelayExecution, 2 
SYSSTUBS_ENTRY2  61, DelayExecution, 2 
SYSSTUBS_ENTRY3  61, DelayExecution, 2 
SYSSTUBS_ENTRY4  61, DelayExecution, 2 
SYSSTUBS_ENTRY5  61, DelayExecution, 2 
SYSSTUBS_ENTRY6  61, DelayExecution, 2 
SYSSTUBS_ENTRY7  61, DelayExecution, 2 
SYSSTUBS_ENTRY8  61, DelayExecution, 2 
SYSSTUBS_ENTRY1  62, DeleteAtom, 1 
SYSSTUBS_ENTRY2  62, DeleteAtom, 1 
SYSSTUBS_ENTRY3  62, DeleteAtom, 1 
SYSSTUBS_ENTRY4  62, DeleteAtom, 1 
SYSSTUBS_ENTRY5  62, DeleteAtom, 1 
SYSSTUBS_ENTRY6  62, DeleteAtom, 1 
SYSSTUBS_ENTRY7  62, DeleteAtom, 1 
SYSSTUBS_ENTRY8  62, DeleteAtom, 1 
SYSSTUBS_ENTRY1  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY2  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY3  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY4  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY5  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY6  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY7  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY8  63, DeleteBootEntry, 1 
SYSSTUBS_ENTRY1  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY2  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY3  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY4  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY5  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY6  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY7  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY8  64, DeleteDriverEntry, 1 
SYSSTUBS_ENTRY1  65, DeleteFile, 1 
SYSSTUBS_ENTRY2  65, DeleteFile, 1 
SYSSTUBS_ENTRY3  65, DeleteFile, 1 
SYSSTUBS_ENTRY4  65, DeleteFile, 1 
SYSSTUBS_ENTRY5  65, DeleteFile, 1 
SYSSTUBS_ENTRY6  65, DeleteFile, 1 
SYSSTUBS_ENTRY7  65, DeleteFile, 1 
SYSSTUBS_ENTRY8  65, DeleteFile, 1 
SYSSTUBS_ENTRY1  66, DeleteKey, 1 
SYSSTUBS_ENTRY2  66, DeleteKey, 1 
SYSSTUBS_ENTRY3  66, DeleteKey, 1 
SYSSTUBS_ENTRY4  66, DeleteKey, 1 
SYSSTUBS_ENTRY5  66, DeleteKey, 1 
SYSSTUBS_ENTRY6  66, DeleteKey, 1 
SYSSTUBS_ENTRY7  66, DeleteKey, 1 
SYSSTUBS_ENTRY8  66, DeleteKey, 1 
SYSSTUBS_ENTRY1  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY2  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY3  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY4  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY5  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY6  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY7  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY8  67, DeleteObjectAuditAlarm, 3 
SYSSTUBS_ENTRY1  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY2  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY3  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY4  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY5  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY6  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY7  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY8  68, DeleteValueKey, 2 
SYSSTUBS_ENTRY1  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY2  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY3  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY4  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY5  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY6  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY7  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY8  69, DeviceIoControlFile, 10 
SYSSTUBS_ENTRY1  70, DisplayString, 1 
SYSSTUBS_ENTRY2  70, DisplayString, 1 
SYSSTUBS_ENTRY3  70, DisplayString, 1 
SYSSTUBS_ENTRY4  70, DisplayString, 1 
SYSSTUBS_ENTRY5  70, DisplayString, 1 
SYSSTUBS_ENTRY6  70, DisplayString, 1 
SYSSTUBS_ENTRY7  70, DisplayString, 1 
SYSSTUBS_ENTRY8  70, DisplayString, 1 
SYSSTUBS_ENTRY1  71, DuplicateObject, 7 
SYSSTUBS_ENTRY2  71, DuplicateObject, 7 
SYSSTUBS_ENTRY3  71, DuplicateObject, 7 
SYSSTUBS_ENTRY4  71, DuplicateObject, 7 
SYSSTUBS_ENTRY5  71, DuplicateObject, 7 
SYSSTUBS_ENTRY6  71, DuplicateObject, 7 
SYSSTUBS_ENTRY7  71, DuplicateObject, 7 
SYSSTUBS_ENTRY8  71, DuplicateObject, 7 
SYSSTUBS_ENTRY1  72, DuplicateToken, 6 
SYSSTUBS_ENTRY2  72, DuplicateToken, 6 
SYSSTUBS_ENTRY3  72, DuplicateToken, 6 
SYSSTUBS_ENTRY4  72, DuplicateToken, 6 
SYSSTUBS_ENTRY5  72, DuplicateToken, 6 
SYSSTUBS_ENTRY6  72, DuplicateToken, 6 
SYSSTUBS_ENTRY7  72, DuplicateToken, 6 
SYSSTUBS_ENTRY8  72, DuplicateToken, 6 
SYSSTUBS_ENTRY1  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY2  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY3  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY4  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY5  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY6  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY7  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY8  73, EnumerateBootEntries, 2 
SYSSTUBS_ENTRY1  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY2  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY3  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY4  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY5  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY6  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY7  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY8  74, EnumerateDriverEntries, 2 
SYSSTUBS_ENTRY1  75, EnumerateKey, 6 
SYSSTUBS_ENTRY2  75, EnumerateKey, 6 
SYSSTUBS_ENTRY3  75, EnumerateKey, 6 
SYSSTUBS_ENTRY4  75, EnumerateKey, 6 
SYSSTUBS_ENTRY5  75, EnumerateKey, 6 
SYSSTUBS_ENTRY6  75, EnumerateKey, 6 
SYSSTUBS_ENTRY7  75, EnumerateKey, 6 
SYSSTUBS_ENTRY8  75, EnumerateKey, 6 
SYSSTUBS_ENTRY1  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY2  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY3  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY4  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY5  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY6  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY7  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY8  76, EnumerateSystemEnvironmentValuesEx, 3 
SYSSTUBS_ENTRY1  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY2  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY3  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY4  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY5  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY6  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY7  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY8  77, EnumerateValueKey, 6 
SYSSTUBS_ENTRY1  78, ExtendSection, 2 
SYSSTUBS_ENTRY2  78, ExtendSection, 2 
SYSSTUBS_ENTRY3  78, ExtendSection, 2 
SYSSTUBS_ENTRY4  78, ExtendSection, 2 
SYSSTUBS_ENTRY5  78, ExtendSection, 2 
SYSSTUBS_ENTRY6  78, ExtendSection, 2 
SYSSTUBS_ENTRY7  78, ExtendSection, 2 
SYSSTUBS_ENTRY8  78, ExtendSection, 2 
SYSSTUBS_ENTRY1  79, FilterToken, 6 
SYSSTUBS_ENTRY2  79, FilterToken, 6 
SYSSTUBS_ENTRY3  79, FilterToken, 6 
SYSSTUBS_ENTRY4  79, FilterToken, 6 
SYSSTUBS_ENTRY5  79, FilterToken, 6 
SYSSTUBS_ENTRY6  79, FilterToken, 6 
SYSSTUBS_ENTRY7  79, FilterToken, 6 
SYSSTUBS_ENTRY8  79, FilterToken, 6 
SYSSTUBS_ENTRY1  80, FindAtom, 3 
SYSSTUBS_ENTRY2  80, FindAtom, 3 
SYSSTUBS_ENTRY3  80, FindAtom, 3 
SYSSTUBS_ENTRY4  80, FindAtom, 3 
SYSSTUBS_ENTRY5  80, FindAtom, 3 
SYSSTUBS_ENTRY6  80, FindAtom, 3 
SYSSTUBS_ENTRY7  80, FindAtom, 3 
SYSSTUBS_ENTRY8  80, FindAtom, 3 
SYSSTUBS_ENTRY1  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY2  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY3  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY4  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY5  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY6  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY7  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY8  81, FlushBuffersFile, 2 
SYSSTUBS_ENTRY1  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY2  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY3  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY4  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY5  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY6  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY7  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY8  82, FlushInstructionCache, 3 
SYSSTUBS_ENTRY1  83, FlushKey, 1 
SYSSTUBS_ENTRY2  83, FlushKey, 1 
SYSSTUBS_ENTRY3  83, FlushKey, 1 
SYSSTUBS_ENTRY4  83, FlushKey, 1 
SYSSTUBS_ENTRY5  83, FlushKey, 1 
SYSSTUBS_ENTRY6  83, FlushKey, 1 
SYSSTUBS_ENTRY7  83, FlushKey, 1 
SYSSTUBS_ENTRY8  83, FlushKey, 1 
SYSSTUBS_ENTRY1  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY2  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY3  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY4  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY5  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY6  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY7  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY8  84, FlushVirtualMemory, 4 
SYSSTUBS_ENTRY1  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY2  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY3  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY4  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY5  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY6  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY7  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY8  85, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY1  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY2  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY3  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY4  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY5  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY6  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY7  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY8  86, FreeUserPhysicalPages, 3 
SYSSTUBS_ENTRY1  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY2  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY3  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY4  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY5  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY6  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY7  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY8  87, FreeVirtualMemory, 4 
SYSSTUBS_ENTRY1  88, FsControlFile, 10 
SYSSTUBS_ENTRY2  88, FsControlFile, 10 
SYSSTUBS_ENTRY3  88, FsControlFile, 10 
SYSSTUBS_ENTRY4  88, FsControlFile, 10 
SYSSTUBS_ENTRY5  88, FsControlFile, 10 
SYSSTUBS_ENTRY6  88, FsControlFile, 10 
SYSSTUBS_ENTRY7  88, FsControlFile, 10 
SYSSTUBS_ENTRY8  88, FsControlFile, 10 
SYSSTUBS_ENTRY1  89, GetContextThread, 2 
SYSSTUBS_ENTRY2  89, GetContextThread, 2 
SYSSTUBS_ENTRY3  89, GetContextThread, 2 
SYSSTUBS_ENTRY4  89, GetContextThread, 2 
SYSSTUBS_ENTRY5  89, GetContextThread, 2 
SYSSTUBS_ENTRY6  89, GetContextThread, 2 
SYSSTUBS_ENTRY7  89, GetContextThread, 2 
SYSSTUBS_ENTRY8  89, GetContextThread, 2 
SYSSTUBS_ENTRY1  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY2  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY3  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY4  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY5  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY6  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY7  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY8  90, GetDevicePowerState, 2 
SYSSTUBS_ENTRY1  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY2  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY3  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY4  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY5  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY6  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY7  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY8  91, GetPlugPlayEvent, 4 
SYSSTUBS_ENTRY1  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY2  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY3  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY4  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY5  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY6  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY7  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY8  92, GetWriteWatch, 7 
SYSSTUBS_ENTRY1  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY2  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY3  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY4  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY5  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY6  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY7  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY8  93, ImpersonateAnonymousToken, 1 
SYSSTUBS_ENTRY1  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY2  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY3  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY4  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY5  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY6  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY7  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY8  94, ImpersonateClientOfPort, 2 
SYSSTUBS_ENTRY1  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY2  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY3  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY4  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY5  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY6  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY7  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY8  95, ImpersonateThread, 3 
SYSSTUBS_ENTRY1  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY2  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY3  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY4  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY5  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY6  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY7  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY8  96, InitializeRegistry, 1 
SYSSTUBS_ENTRY1  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY2  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY3  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY4  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY5  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY6  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY7  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY8  97, InitiatePowerAction, 4 
SYSSTUBS_ENTRY1  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY2  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY3  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY4  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY5  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY6  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY7  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY8  98, IsProcessInJob, 2 
SYSSTUBS_ENTRY1  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY2  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY3  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY4  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY5  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY6  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY7  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY8  99, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY1  100, ListenPort, 2 
SYSSTUBS_ENTRY2  100, ListenPort, 2 
SYSSTUBS_ENTRY3  100, ListenPort, 2 
SYSSTUBS_ENTRY4  100, ListenPort, 2 
SYSSTUBS_ENTRY5  100, ListenPort, 2 
SYSSTUBS_ENTRY6  100, ListenPort, 2 
SYSSTUBS_ENTRY7  100, ListenPort, 2 
SYSSTUBS_ENTRY8  100, ListenPort, 2 
SYSSTUBS_ENTRY1  101, LoadDriver, 1 
SYSSTUBS_ENTRY2  101, LoadDriver, 1 
SYSSTUBS_ENTRY3  101, LoadDriver, 1 
SYSSTUBS_ENTRY4  101, LoadDriver, 1 
SYSSTUBS_ENTRY5  101, LoadDriver, 1 
SYSSTUBS_ENTRY6  101, LoadDriver, 1 
SYSSTUBS_ENTRY7  101, LoadDriver, 1 
SYSSTUBS_ENTRY8  101, LoadDriver, 1 
SYSSTUBS_ENTRY1  102, LoadKey, 2 
SYSSTUBS_ENTRY2  102, LoadKey, 2 
SYSSTUBS_ENTRY3  102, LoadKey, 2 
SYSSTUBS_ENTRY4  102, LoadKey, 2 
SYSSTUBS_ENTRY5  102, LoadKey, 2 
SYSSTUBS_ENTRY6  102, LoadKey, 2 
SYSSTUBS_ENTRY7  102, LoadKey, 2 
SYSSTUBS_ENTRY8  102, LoadKey, 2 
SYSSTUBS_ENTRY1  103, LoadKey2, 3 
SYSSTUBS_ENTRY2  103, LoadKey2, 3 
SYSSTUBS_ENTRY3  103, LoadKey2, 3 
SYSSTUBS_ENTRY4  103, LoadKey2, 3 
SYSSTUBS_ENTRY5  103, LoadKey2, 3 
SYSSTUBS_ENTRY6  103, LoadKey2, 3 
SYSSTUBS_ENTRY7  103, LoadKey2, 3 
SYSSTUBS_ENTRY8  103, LoadKey2, 3 
SYSSTUBS_ENTRY1  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY2  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY3  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY4  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY5  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY6  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY7  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY8  104, LoadKeyEx, 4 
SYSSTUBS_ENTRY1  105, LockFile, 10 
SYSSTUBS_ENTRY2  105, LockFile, 10 
SYSSTUBS_ENTRY3  105, LockFile, 10 
SYSSTUBS_ENTRY4  105, LockFile, 10 
SYSSTUBS_ENTRY5  105, LockFile, 10 
SYSSTUBS_ENTRY6  105, LockFile, 10 
SYSSTUBS_ENTRY7  105, LockFile, 10 
SYSSTUBS_ENTRY8  105, LockFile, 10 
SYSSTUBS_ENTRY1  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY2  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY3  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY4  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY5  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY6  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY7  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY8  106, LockProductActivationKeys, 2 
SYSSTUBS_ENTRY1  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY2  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY3  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY4  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY5  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY6  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY7  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY8  107, LockRegistryKey, 1 
SYSSTUBS_ENTRY1  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY2  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY3  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY4  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY5  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY6  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY7  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY8  108, LockVirtualMemory, 4 
SYSSTUBS_ENTRY1  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY2  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY3  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY4  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY5  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY6  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY7  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY8  109, MakePermanentObject, 1 
SYSSTUBS_ENTRY1  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY2  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY3  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY4  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY5  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY6  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY7  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY8  110, MakeTemporaryObject, 1 
SYSSTUBS_ENTRY1  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY2  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY3  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY4  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY5  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY6  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY7  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY8  111, MapUserPhysicalPages, 3 
SYSSTUBS_ENTRY1  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY2  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY3  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY4  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY5  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY6  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY7  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY8  112, MapUserPhysicalPagesScatter, 3 
SYSSTUBS_ENTRY1  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY2  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY3  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY4  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY5  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY6  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY7  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY8  113, MapViewOfSection, 10 
SYSSTUBS_ENTRY1  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY2  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY3  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY4  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY5  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY6  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY7  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY8  114, ModifyBootEntry, 1 
SYSSTUBS_ENTRY1  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY2  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY3  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY4  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY5  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY6  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY7  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY8  115, ModifyDriverEntry, 1 
SYSSTUBS_ENTRY1  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY2  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY3  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY4  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY5  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY6  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY7  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY8  116, NotifyChangeDirectoryFile, 9 
SYSSTUBS_ENTRY1  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY2  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY3  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY4  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY5  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY6  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY7  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY8  117, NotifyChangeKey, 10 
SYSSTUBS_ENTRY1  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY2  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY3  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY4  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY5  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY6  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY7  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY8  118, NotifyChangeMultipleKeys, 12 
SYSSTUBS_ENTRY1  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY2  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY3  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY4  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY5  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY6  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY7  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY8  119, OpenDirectoryObject, 3 
SYSSTUBS_ENTRY1  120, OpenEvent, 3 
SYSSTUBS_ENTRY2  120, OpenEvent, 3 
SYSSTUBS_ENTRY3  120, OpenEvent, 3 
SYSSTUBS_ENTRY4  120, OpenEvent, 3 
SYSSTUBS_ENTRY5  120, OpenEvent, 3 
SYSSTUBS_ENTRY6  120, OpenEvent, 3 
SYSSTUBS_ENTRY7  120, OpenEvent, 3 
SYSSTUBS_ENTRY8  120, OpenEvent, 3 
SYSSTUBS_ENTRY1  121, OpenEventPair, 3 
SYSSTUBS_ENTRY2  121, OpenEventPair, 3 
SYSSTUBS_ENTRY3  121, OpenEventPair, 3 
SYSSTUBS_ENTRY4  121, OpenEventPair, 3 
SYSSTUBS_ENTRY5  121, OpenEventPair, 3 
SYSSTUBS_ENTRY6  121, OpenEventPair, 3 
SYSSTUBS_ENTRY7  121, OpenEventPair, 3 
SYSSTUBS_ENTRY8  121, OpenEventPair, 3 
SYSSTUBS_ENTRY1  122, OpenFile, 6 
SYSSTUBS_ENTRY2  122, OpenFile, 6 
SYSSTUBS_ENTRY3  122, OpenFile, 6 
SYSSTUBS_ENTRY4  122, OpenFile, 6 
SYSSTUBS_ENTRY5  122, OpenFile, 6 
SYSSTUBS_ENTRY6  122, OpenFile, 6 
SYSSTUBS_ENTRY7  122, OpenFile, 6 
SYSSTUBS_ENTRY8  122, OpenFile, 6 
SYSSTUBS_ENTRY1  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY2  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY3  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY4  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY5  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY6  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY7  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY8  123, OpenIoCompletion, 3 
SYSSTUBS_ENTRY1  124, OpenJobObject, 3 
SYSSTUBS_ENTRY2  124, OpenJobObject, 3 
SYSSTUBS_ENTRY3  124, OpenJobObject, 3 
SYSSTUBS_ENTRY4  124, OpenJobObject, 3 
SYSSTUBS_ENTRY5  124, OpenJobObject, 3 
SYSSTUBS_ENTRY6  124, OpenJobObject, 3 
SYSSTUBS_ENTRY7  124, OpenJobObject, 3 
SYSSTUBS_ENTRY8  124, OpenJobObject, 3 
SYSSTUBS_ENTRY1  125, OpenKey, 3 
SYSSTUBS_ENTRY2  125, OpenKey, 3 
SYSSTUBS_ENTRY3  125, OpenKey, 3 
SYSSTUBS_ENTRY4  125, OpenKey, 3 
SYSSTUBS_ENTRY5  125, OpenKey, 3 
SYSSTUBS_ENTRY6  125, OpenKey, 3 
SYSSTUBS_ENTRY7  125, OpenKey, 3 
SYSSTUBS_ENTRY8  125, OpenKey, 3 
SYSSTUBS_ENTRY1  126, OpenMutant, 3 
SYSSTUBS_ENTRY2  126, OpenMutant, 3 
SYSSTUBS_ENTRY3  126, OpenMutant, 3 
SYSSTUBS_ENTRY4  126, OpenMutant, 3 
SYSSTUBS_ENTRY5  126, OpenMutant, 3 
SYSSTUBS_ENTRY6  126, OpenMutant, 3 
SYSSTUBS_ENTRY7  126, OpenMutant, 3 
SYSSTUBS_ENTRY8  126, OpenMutant, 3 
SYSSTUBS_ENTRY1  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY2  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY3  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY4  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY5  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY6  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY7  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY8  127, OpenObjectAuditAlarm, 12 
SYSSTUBS_ENTRY1  128, OpenProcess, 4 
SYSSTUBS_ENTRY2  128, OpenProcess, 4 
SYSSTUBS_ENTRY3  128, OpenProcess, 4 
SYSSTUBS_ENTRY4  128, OpenProcess, 4 
SYSSTUBS_ENTRY5  128, OpenProcess, 4 
SYSSTUBS_ENTRY6  128, OpenProcess, 4 
SYSSTUBS_ENTRY7  128, OpenProcess, 4 
SYSSTUBS_ENTRY8  128, OpenProcess, 4 
SYSSTUBS_ENTRY1  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY2  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY3  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY4  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY5  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY6  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY7  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY8  129, OpenProcessToken, 3 
SYSSTUBS_ENTRY1  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY2  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY3  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY4  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY5  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY6  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY7  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY8  130, OpenProcessTokenEx, 4 
SYSSTUBS_ENTRY1  131, OpenSection, 3 
SYSSTUBS_ENTRY2  131, OpenSection, 3 
SYSSTUBS_ENTRY3  131, OpenSection, 3 
SYSSTUBS_ENTRY4  131, OpenSection, 3 
SYSSTUBS_ENTRY5  131, OpenSection, 3 
SYSSTUBS_ENTRY6  131, OpenSection, 3 
SYSSTUBS_ENTRY7  131, OpenSection, 3 
SYSSTUBS_ENTRY8  131, OpenSection, 3 
SYSSTUBS_ENTRY1  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY2  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY3  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY4  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY5  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY6  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY7  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY8  132, OpenSemaphore, 3 
SYSSTUBS_ENTRY1  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY2  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY3  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY4  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY5  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY6  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY7  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY8  133, OpenSymbolicLinkObject, 3 
SYSSTUBS_ENTRY1  134, OpenThread, 4 
SYSSTUBS_ENTRY2  134, OpenThread, 4 
SYSSTUBS_ENTRY3  134, OpenThread, 4 
SYSSTUBS_ENTRY4  134, OpenThread, 4 
SYSSTUBS_ENTRY5  134, OpenThread, 4 
SYSSTUBS_ENTRY6  134, OpenThread, 4 
SYSSTUBS_ENTRY7  134, OpenThread, 4 
SYSSTUBS_ENTRY8  134, OpenThread, 4 
SYSSTUBS_ENTRY1  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY2  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY3  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY4  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY5  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY6  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY7  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY8  135, OpenThreadToken, 4 
SYSSTUBS_ENTRY1  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY2  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY3  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY4  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY5  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY6  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY7  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY8  136, OpenThreadTokenEx, 5 
SYSSTUBS_ENTRY1  137, OpenTimer, 3 
SYSSTUBS_ENTRY2  137, OpenTimer, 3 
SYSSTUBS_ENTRY3  137, OpenTimer, 3 
SYSSTUBS_ENTRY4  137, OpenTimer, 3 
SYSSTUBS_ENTRY5  137, OpenTimer, 3 
SYSSTUBS_ENTRY6  137, OpenTimer, 3 
SYSSTUBS_ENTRY7  137, OpenTimer, 3 
SYSSTUBS_ENTRY8  137, OpenTimer, 3 
SYSSTUBS_ENTRY1  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY2  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY3  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY4  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY5  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY6  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY7  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY8  138, PlugPlayControl, 3 
SYSSTUBS_ENTRY1  139, PowerInformation, 5 
SYSSTUBS_ENTRY2  139, PowerInformation, 5 
SYSSTUBS_ENTRY3  139, PowerInformation, 5 
SYSSTUBS_ENTRY4  139, PowerInformation, 5 
SYSSTUBS_ENTRY5  139, PowerInformation, 5 
SYSSTUBS_ENTRY6  139, PowerInformation, 5 
SYSSTUBS_ENTRY7  139, PowerInformation, 5 
SYSSTUBS_ENTRY8  139, PowerInformation, 5 
SYSSTUBS_ENTRY1  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY2  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY3  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY4  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY5  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY6  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY7  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY8  140, PrivilegeCheck, 3 
SYSSTUBS_ENTRY1  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY2  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY3  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY4  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY5  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY6  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY7  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY8  141, PrivilegeObjectAuditAlarm, 6 
SYSSTUBS_ENTRY1  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY2  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY3  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY4  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY5  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY6  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY7  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY8  142, PrivilegedServiceAuditAlarm, 5 
SYSSTUBS_ENTRY1  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY2  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY3  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY4  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY5  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY6  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY7  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY8  143, ProtectVirtualMemory, 5 
SYSSTUBS_ENTRY1  144, PulseEvent, 2 
SYSSTUBS_ENTRY2  144, PulseEvent, 2 
SYSSTUBS_ENTRY3  144, PulseEvent, 2 
SYSSTUBS_ENTRY4  144, PulseEvent, 2 
SYSSTUBS_ENTRY5  144, PulseEvent, 2 
SYSSTUBS_ENTRY6  144, PulseEvent, 2 
SYSSTUBS_ENTRY7  144, PulseEvent, 2 
SYSSTUBS_ENTRY8  144, PulseEvent, 2 
SYSSTUBS_ENTRY1  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY2  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY3  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY4  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY5  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY6  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY7  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY8  145, QueryAttributesFile, 2 
SYSSTUBS_ENTRY1  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY2  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY3  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY4  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY5  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY6  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY7  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY8  146, QueryBootEntryOrder, 2 
SYSSTUBS_ENTRY1  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY2  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY3  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY4  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY5  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY6  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY7  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY8  147, QueryBootOptions, 2 
SYSSTUBS_ENTRY1  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY2  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY3  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY4  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY5  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY6  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY7  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY8  148, QueryDebugFilterState, 2 
SYSSTUBS_ENTRY1  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY2  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY3  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY4  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY5  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY6  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY7  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY8  149, QueryDefaultLocale, 2 
SYSSTUBS_ENTRY1  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY2  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY3  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY4  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY5  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY6  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY7  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY8  150, QueryDefaultUILanguage, 1 
SYSSTUBS_ENTRY1  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY2  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY3  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY4  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY5  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY6  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY7  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY8  151, QueryDirectoryFile, 11 
SYSSTUBS_ENTRY1  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY2  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY3  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY4  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY5  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY6  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY7  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY8  152, QueryDirectoryObject, 7 
SYSSTUBS_ENTRY1  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY2  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY3  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY4  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY5  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY6  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY7  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY8  153, QueryDriverEntryOrder, 2 
SYSSTUBS_ENTRY1  154, QueryEaFile, 9 
SYSSTUBS_ENTRY2  154, QueryEaFile, 9 
SYSSTUBS_ENTRY3  154, QueryEaFile, 9 
SYSSTUBS_ENTRY4  154, QueryEaFile, 9 
SYSSTUBS_ENTRY5  154, QueryEaFile, 9 
SYSSTUBS_ENTRY6  154, QueryEaFile, 9 
SYSSTUBS_ENTRY7  154, QueryEaFile, 9 
SYSSTUBS_ENTRY8  154, QueryEaFile, 9 
SYSSTUBS_ENTRY1  155, QueryEvent, 5 
SYSSTUBS_ENTRY2  155, QueryEvent, 5 
SYSSTUBS_ENTRY3  155, QueryEvent, 5 
SYSSTUBS_ENTRY4  155, QueryEvent, 5 
SYSSTUBS_ENTRY5  155, QueryEvent, 5 
SYSSTUBS_ENTRY6  155, QueryEvent, 5 
SYSSTUBS_ENTRY7  155, QueryEvent, 5 
SYSSTUBS_ENTRY8  155, QueryEvent, 5 
SYSSTUBS_ENTRY1  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY2  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY3  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY4  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY5  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY6  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY7  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY8  156, QueryFullAttributesFile, 2 
SYSSTUBS_ENTRY1  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY2  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY3  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY4  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY5  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY6  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY7  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY8  157, QueryInformationAtom, 5 
SYSSTUBS_ENTRY1  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY2  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY3  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY4  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY5  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY6  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY7  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY8  158, QueryInformationFile, 5 
SYSSTUBS_ENTRY1  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY2  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY3  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY4  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY5  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY6  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY7  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY8  159, QueryInformationJobObject, 5 
SYSSTUBS_ENTRY1  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY2  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY3  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY4  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY5  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY6  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY7  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY8  160, QueryInformationPort, 5 
SYSSTUBS_ENTRY1  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY2  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY3  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY4  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY5  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY6  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY7  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY8  161, QueryInformationProcess, 5 
SYSSTUBS_ENTRY1  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY2  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY3  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY4  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY5  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY6  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY7  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY8  162, QueryInformationThread, 5 
SYSSTUBS_ENTRY1  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY2  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY3  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY4  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY5  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY6  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY7  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY8  163, QueryInformationToken, 5 
SYSSTUBS_ENTRY1  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY2  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY3  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY4  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY5  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY6  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY7  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY8  164, QueryInstallUILanguage, 1 
SYSSTUBS_ENTRY1  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY2  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY3  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY4  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY5  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY6  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY7  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY8  165, QueryIntervalProfile, 2 
SYSSTUBS_ENTRY1  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY2  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY3  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY4  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY5  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY6  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY7  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY8  166, QueryIoCompletion, 5 
SYSSTUBS_ENTRY1  167, QueryKey, 5 
SYSSTUBS_ENTRY2  167, QueryKey, 5 
SYSSTUBS_ENTRY3  167, QueryKey, 5 
SYSSTUBS_ENTRY4  167, QueryKey, 5 
SYSSTUBS_ENTRY5  167, QueryKey, 5 
SYSSTUBS_ENTRY6  167, QueryKey, 5 
SYSSTUBS_ENTRY7  167, QueryKey, 5 
SYSSTUBS_ENTRY8  167, QueryKey, 5 
SYSSTUBS_ENTRY1  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY2  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY3  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY4  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY5  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY6  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY7  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY8  168, QueryMultipleValueKey, 6 
SYSSTUBS_ENTRY1  169, QueryMutant, 5 
SYSSTUBS_ENTRY2  169, QueryMutant, 5 
SYSSTUBS_ENTRY3  169, QueryMutant, 5 
SYSSTUBS_ENTRY4  169, QueryMutant, 5 
SYSSTUBS_ENTRY5  169, QueryMutant, 5 
SYSSTUBS_ENTRY6  169, QueryMutant, 5 
SYSSTUBS_ENTRY7  169, QueryMutant, 5 
SYSSTUBS_ENTRY8  169, QueryMutant, 5 
SYSSTUBS_ENTRY1  170, QueryObject, 5 
SYSSTUBS_ENTRY2  170, QueryObject, 5 
SYSSTUBS_ENTRY3  170, QueryObject, 5 
SYSSTUBS_ENTRY4  170, QueryObject, 5 
SYSSTUBS_ENTRY5  170, QueryObject, 5 
SYSSTUBS_ENTRY6  170, QueryObject, 5 
SYSSTUBS_ENTRY7  170, QueryObject, 5 
SYSSTUBS_ENTRY8  170, QueryObject, 5 
SYSSTUBS_ENTRY1  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY2  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY3  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY4  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY5  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY6  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY7  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY8  171, QueryOpenSubKeys, 2 
SYSSTUBS_ENTRY1  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY2  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY3  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY4  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY5  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY6  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY7  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY8  172, QueryOpenSubKeysEx, 4 
SYSSTUBS_ENTRY1  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY2  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY3  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY4  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY5  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY6  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY7  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY8  173, QueryPerformanceCounter, 2 
SYSSTUBS_ENTRY1  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY2  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY3  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY4  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY5  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY6  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY7  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY8  174, QueryQuotaInformationFile, 9 
SYSSTUBS_ENTRY1  175, QuerySection, 5 
SYSSTUBS_ENTRY2  175, QuerySection, 5 
SYSSTUBS_ENTRY3  175, QuerySection, 5 
SYSSTUBS_ENTRY4  175, QuerySection, 5 
SYSSTUBS_ENTRY5  175, QuerySection, 5 
SYSSTUBS_ENTRY6  175, QuerySection, 5 
SYSSTUBS_ENTRY7  175, QuerySection, 5 
SYSSTUBS_ENTRY8  175, QuerySection, 5 
SYSSTUBS_ENTRY1  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY2  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY3  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY4  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY5  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY6  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY7  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY8  176, QuerySecurityObject, 5 
SYSSTUBS_ENTRY1  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY2  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY3  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY4  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY5  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY6  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY7  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY8  177, QuerySemaphore, 5 
SYSSTUBS_ENTRY1  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY2  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY3  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY4  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY5  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY6  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY7  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY8  178, QuerySymbolicLinkObject, 3 
SYSSTUBS_ENTRY1  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY2  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY3  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY4  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY5  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY6  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY7  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY8  179, QuerySystemEnvironmentValue, 4 
SYSSTUBS_ENTRY1  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY2  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY3  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY4  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY5  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY6  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY7  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY8  180, QuerySystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY1  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY2  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY3  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY4  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY5  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY6  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY7  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY8  181, QuerySystemInformation, 4 
SYSSTUBS_ENTRY1  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY2  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY3  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY4  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY5  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY6  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY7  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY8  182, QuerySystemTime, 1 
SYSSTUBS_ENTRY1  183, QueryTimer, 5 
SYSSTUBS_ENTRY2  183, QueryTimer, 5 
SYSSTUBS_ENTRY3  183, QueryTimer, 5 
SYSSTUBS_ENTRY4  183, QueryTimer, 5 
SYSSTUBS_ENTRY5  183, QueryTimer, 5 
SYSSTUBS_ENTRY6  183, QueryTimer, 5 
SYSSTUBS_ENTRY7  183, QueryTimer, 5 
SYSSTUBS_ENTRY8  183, QueryTimer, 5 
SYSSTUBS_ENTRY1  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY2  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY3  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY4  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY5  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY6  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY7  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY8  184, QueryTimerResolution, 3 
SYSSTUBS_ENTRY1  185, QueryValueKey, 6 
SYSSTUBS_ENTRY2  185, QueryValueKey, 6 
SYSSTUBS_ENTRY3  185, QueryValueKey, 6 
SYSSTUBS_ENTRY4  185, QueryValueKey, 6 
SYSSTUBS_ENTRY5  185, QueryValueKey, 6 
SYSSTUBS_ENTRY6  185, QueryValueKey, 6 
SYSSTUBS_ENTRY7  185, QueryValueKey, 6 
SYSSTUBS_ENTRY8  185, QueryValueKey, 6 
SYSSTUBS_ENTRY1  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY2  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY3  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY4  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY5  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY6  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY7  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY8  186, QueryVirtualMemory, 6 
SYSSTUBS_ENTRY1  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY2  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY3  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY4  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY5  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY6  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY7  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY8  187, QueryVolumeInformationFile, 5 
SYSSTUBS_ENTRY1  188, QueueApcThread, 5 
SYSSTUBS_ENTRY2  188, QueueApcThread, 5 
SYSSTUBS_ENTRY3  188, QueueApcThread, 5 
SYSSTUBS_ENTRY4  188, QueueApcThread, 5 
SYSSTUBS_ENTRY5  188, QueueApcThread, 5 
SYSSTUBS_ENTRY6  188, QueueApcThread, 5 
SYSSTUBS_ENTRY7  188, QueueApcThread, 5 
SYSSTUBS_ENTRY8  188, QueueApcThread, 5 
SYSSTUBS_ENTRY1  189, RaiseException, 3 
SYSSTUBS_ENTRY2  189, RaiseException, 3 
SYSSTUBS_ENTRY3  189, RaiseException, 3 
SYSSTUBS_ENTRY4  189, RaiseException, 3 
SYSSTUBS_ENTRY5  189, RaiseException, 3 
SYSSTUBS_ENTRY6  189, RaiseException, 3 
SYSSTUBS_ENTRY7  189, RaiseException, 3 
SYSSTUBS_ENTRY8  189, RaiseException, 3 
SYSSTUBS_ENTRY1  190, RaiseHardError, 6 
SYSSTUBS_ENTRY2  190, RaiseHardError, 6 
SYSSTUBS_ENTRY3  190, RaiseHardError, 6 
SYSSTUBS_ENTRY4  190, RaiseHardError, 6 
SYSSTUBS_ENTRY5  190, RaiseHardError, 6 
SYSSTUBS_ENTRY6  190, RaiseHardError, 6 
SYSSTUBS_ENTRY7  190, RaiseHardError, 6 
SYSSTUBS_ENTRY8  190, RaiseHardError, 6 
SYSSTUBS_ENTRY1  191, ReadFile, 9 
SYSSTUBS_ENTRY2  191, ReadFile, 9 
SYSSTUBS_ENTRY3  191, ReadFile, 9 
SYSSTUBS_ENTRY4  191, ReadFile, 9 
SYSSTUBS_ENTRY5  191, ReadFile, 9 
SYSSTUBS_ENTRY6  191, ReadFile, 9 
SYSSTUBS_ENTRY7  191, ReadFile, 9 
SYSSTUBS_ENTRY8  191, ReadFile, 9 
SYSSTUBS_ENTRY1  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY2  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY3  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY4  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY5  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY6  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY7  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY8  192, ReadFileScatter, 9 
SYSSTUBS_ENTRY1  193, ReadRequestData, 6 
SYSSTUBS_ENTRY2  193, ReadRequestData, 6 
SYSSTUBS_ENTRY3  193, ReadRequestData, 6 
SYSSTUBS_ENTRY4  193, ReadRequestData, 6 
SYSSTUBS_ENTRY5  193, ReadRequestData, 6 
SYSSTUBS_ENTRY6  193, ReadRequestData, 6 
SYSSTUBS_ENTRY7  193, ReadRequestData, 6 
SYSSTUBS_ENTRY8  193, ReadRequestData, 6 
SYSSTUBS_ENTRY1  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY2  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY3  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY4  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY5  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY6  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY7  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY8  194, ReadVirtualMemory, 5 
SYSSTUBS_ENTRY1  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY2  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY3  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY4  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY5  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY6  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY7  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY8  195, RegisterThreadTerminatePort, 1 
SYSSTUBS_ENTRY1  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY2  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY3  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY4  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY5  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY6  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY7  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY8  196, ReleaseMutant, 2 
SYSSTUBS_ENTRY1  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY2  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY3  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY4  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY5  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY6  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY7  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY8  197, ReleaseSemaphore, 3 
SYSSTUBS_ENTRY1  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY2  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY3  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY4  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY5  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY6  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY7  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY8  198, RemoveIoCompletion, 5 
SYSSTUBS_ENTRY1  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY2  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY3  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY4  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY5  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY6  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY7  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY8  199, RemoveProcessDebug, 2 
SYSSTUBS_ENTRY1  200, RenameKey, 2 
SYSSTUBS_ENTRY2  200, RenameKey, 2 
SYSSTUBS_ENTRY3  200, RenameKey, 2 
SYSSTUBS_ENTRY4  200, RenameKey, 2 
SYSSTUBS_ENTRY5  200, RenameKey, 2 
SYSSTUBS_ENTRY6  200, RenameKey, 2 
SYSSTUBS_ENTRY7  200, RenameKey, 2 
SYSSTUBS_ENTRY8  200, RenameKey, 2 
SYSSTUBS_ENTRY1  201, ReplaceKey, 3 
SYSSTUBS_ENTRY2  201, ReplaceKey, 3 
SYSSTUBS_ENTRY3  201, ReplaceKey, 3 
SYSSTUBS_ENTRY4  201, ReplaceKey, 3 
SYSSTUBS_ENTRY5  201, ReplaceKey, 3 
SYSSTUBS_ENTRY6  201, ReplaceKey, 3 
SYSSTUBS_ENTRY7  201, ReplaceKey, 3 
SYSSTUBS_ENTRY8  201, ReplaceKey, 3 
SYSSTUBS_ENTRY1  202, ReplyPort, 2 
SYSSTUBS_ENTRY2  202, ReplyPort, 2 
SYSSTUBS_ENTRY3  202, ReplyPort, 2 
SYSSTUBS_ENTRY4  202, ReplyPort, 2 
SYSSTUBS_ENTRY5  202, ReplyPort, 2 
SYSSTUBS_ENTRY6  202, ReplyPort, 2 
SYSSTUBS_ENTRY7  202, ReplyPort, 2 
SYSSTUBS_ENTRY8  202, ReplyPort, 2 
SYSSTUBS_ENTRY1  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY2  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY3  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY4  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY5  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY6  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY7  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY8  203, ReplyWaitReceivePort, 4 
SYSSTUBS_ENTRY1  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY2  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY3  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY4  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY5  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY6  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY7  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY8  204, ReplyWaitReceivePortEx, 5 
SYSSTUBS_ENTRY1  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY2  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY3  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY4  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY5  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY6  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY7  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY8  205, ReplyWaitReplyPort, 2 
SYSSTUBS_ENTRY1  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY2  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY3  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY4  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY5  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY6  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY7  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY8  206, RequestDeviceWakeup, 1 
SYSSTUBS_ENTRY1  207, RequestPort, 2 
SYSSTUBS_ENTRY2  207, RequestPort, 2 
SYSSTUBS_ENTRY3  207, RequestPort, 2 
SYSSTUBS_ENTRY4  207, RequestPort, 2 
SYSSTUBS_ENTRY5  207, RequestPort, 2 
SYSSTUBS_ENTRY6  207, RequestPort, 2 
SYSSTUBS_ENTRY7  207, RequestPort, 2 
SYSSTUBS_ENTRY8  207, RequestPort, 2 
SYSSTUBS_ENTRY1  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY2  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY3  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY4  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY5  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY6  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY7  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY8  208, RequestWaitReplyPort, 3 
SYSSTUBS_ENTRY1  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY2  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY3  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY4  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY5  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY6  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY7  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY8  209, RequestWakeupLatency, 1 
SYSSTUBS_ENTRY1  210, ResetEvent, 2 
SYSSTUBS_ENTRY2  210, ResetEvent, 2 
SYSSTUBS_ENTRY3  210, ResetEvent, 2 
SYSSTUBS_ENTRY4  210, ResetEvent, 2 
SYSSTUBS_ENTRY5  210, ResetEvent, 2 
SYSSTUBS_ENTRY6  210, ResetEvent, 2 
SYSSTUBS_ENTRY7  210, ResetEvent, 2 
SYSSTUBS_ENTRY8  210, ResetEvent, 2 
SYSSTUBS_ENTRY1  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY2  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY3  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY4  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY5  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY6  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY7  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY8  211, ResetWriteWatch, 3 
SYSSTUBS_ENTRY1  212, RestoreKey, 3 
SYSSTUBS_ENTRY2  212, RestoreKey, 3 
SYSSTUBS_ENTRY3  212, RestoreKey, 3 
SYSSTUBS_ENTRY4  212, RestoreKey, 3 
SYSSTUBS_ENTRY5  212, RestoreKey, 3 
SYSSTUBS_ENTRY6  212, RestoreKey, 3 
SYSSTUBS_ENTRY7  212, RestoreKey, 3 
SYSSTUBS_ENTRY8  212, RestoreKey, 3 
SYSSTUBS_ENTRY1  213, ResumeProcess, 1 
SYSSTUBS_ENTRY2  213, ResumeProcess, 1 
SYSSTUBS_ENTRY3  213, ResumeProcess, 1 
SYSSTUBS_ENTRY4  213, ResumeProcess, 1 
SYSSTUBS_ENTRY5  213, ResumeProcess, 1 
SYSSTUBS_ENTRY6  213, ResumeProcess, 1 
SYSSTUBS_ENTRY7  213, ResumeProcess, 1 
SYSSTUBS_ENTRY8  213, ResumeProcess, 1 
SYSSTUBS_ENTRY1  214, ResumeThread, 2 
SYSSTUBS_ENTRY2  214, ResumeThread, 2 
SYSSTUBS_ENTRY3  214, ResumeThread, 2 
SYSSTUBS_ENTRY4  214, ResumeThread, 2 
SYSSTUBS_ENTRY5  214, ResumeThread, 2 
SYSSTUBS_ENTRY6  214, ResumeThread, 2 
SYSSTUBS_ENTRY7  214, ResumeThread, 2 
SYSSTUBS_ENTRY8  214, ResumeThread, 2 
SYSSTUBS_ENTRY1  215, SaveKey, 2 
SYSSTUBS_ENTRY2  215, SaveKey, 2 
SYSSTUBS_ENTRY3  215, SaveKey, 2 
SYSSTUBS_ENTRY4  215, SaveKey, 2 
SYSSTUBS_ENTRY5  215, SaveKey, 2 
SYSSTUBS_ENTRY6  215, SaveKey, 2 
SYSSTUBS_ENTRY7  215, SaveKey, 2 
SYSSTUBS_ENTRY8  215, SaveKey, 2 
SYSSTUBS_ENTRY1  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY2  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY3  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY4  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY5  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY6  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY7  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY8  216, SaveKeyEx, 3 
SYSSTUBS_ENTRY1  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY2  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY3  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY4  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY5  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY6  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY7  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY8  217, SaveMergedKeys, 3 
SYSSTUBS_ENTRY1  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY2  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY3  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY4  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY5  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY6  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY7  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY8  218, SecureConnectPort, 9 
SYSSTUBS_ENTRY1  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY2  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY3  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY4  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY5  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY6  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY7  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY8  219, SetBootEntryOrder, 2 
SYSSTUBS_ENTRY1  220, SetBootOptions, 2 
SYSSTUBS_ENTRY2  220, SetBootOptions, 2 
SYSSTUBS_ENTRY3  220, SetBootOptions, 2 
SYSSTUBS_ENTRY4  220, SetBootOptions, 2 
SYSSTUBS_ENTRY5  220, SetBootOptions, 2 
SYSSTUBS_ENTRY6  220, SetBootOptions, 2 
SYSSTUBS_ENTRY7  220, SetBootOptions, 2 
SYSSTUBS_ENTRY8  220, SetBootOptions, 2 
SYSSTUBS_ENTRY1  221, SetContextThread, 2 
SYSSTUBS_ENTRY2  221, SetContextThread, 2 
SYSSTUBS_ENTRY3  221, SetContextThread, 2 
SYSSTUBS_ENTRY4  221, SetContextThread, 2 
SYSSTUBS_ENTRY5  221, SetContextThread, 2 
SYSSTUBS_ENTRY6  221, SetContextThread, 2 
SYSSTUBS_ENTRY7  221, SetContextThread, 2 
SYSSTUBS_ENTRY8  221, SetContextThread, 2 
SYSSTUBS_ENTRY1  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY2  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY3  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY4  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY5  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY6  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY7  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY8  222, SetDebugFilterState, 3 
SYSSTUBS_ENTRY1  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY2  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY3  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY4  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY5  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY6  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY7  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY8  223, SetDefaultHardErrorPort, 1 
SYSSTUBS_ENTRY1  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY2  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY3  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY4  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY5  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY6  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY7  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY8  224, SetDefaultLocale, 2 
SYSSTUBS_ENTRY1  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY2  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY3  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY4  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY5  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY6  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY7  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY8  225, SetDefaultUILanguage, 1 
SYSSTUBS_ENTRY1  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY2  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY3  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY4  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY5  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY6  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY7  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY8  226, SetDriverEntryOrder, 2 
SYSSTUBS_ENTRY1  227, SetEaFile, 4 
SYSSTUBS_ENTRY2  227, SetEaFile, 4 
SYSSTUBS_ENTRY3  227, SetEaFile, 4 
SYSSTUBS_ENTRY4  227, SetEaFile, 4 
SYSSTUBS_ENTRY5  227, SetEaFile, 4 
SYSSTUBS_ENTRY6  227, SetEaFile, 4 
SYSSTUBS_ENTRY7  227, SetEaFile, 4 
SYSSTUBS_ENTRY8  227, SetEaFile, 4 
SYSSTUBS_ENTRY1  228, SetEvent, 2 
SYSSTUBS_ENTRY2  228, SetEvent, 2 
SYSSTUBS_ENTRY3  228, SetEvent, 2 
SYSSTUBS_ENTRY4  228, SetEvent, 2 
SYSSTUBS_ENTRY5  228, SetEvent, 2 
SYSSTUBS_ENTRY6  228, SetEvent, 2 
SYSSTUBS_ENTRY7  228, SetEvent, 2 
SYSSTUBS_ENTRY8  228, SetEvent, 2 
SYSSTUBS_ENTRY1  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY2  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY3  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY4  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY5  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY6  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY7  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY8  229, SetEventBoostPriority, 1 
SYSSTUBS_ENTRY1  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY2  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY3  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY4  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY5  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY6  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY7  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY8  230, SetHighEventPair, 1 
SYSSTUBS_ENTRY1  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY2  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY3  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY4  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY5  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY6  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY7  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY8  231, SetHighWaitLowEventPair, 1 
SYSSTUBS_ENTRY1  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY2  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY3  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY4  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY5  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY6  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY7  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY8  232, SetInformationDebugObject, 5 
SYSSTUBS_ENTRY1  233, SetInformationFile, 5 
SYSSTUBS_ENTRY2  233, SetInformationFile, 5 
SYSSTUBS_ENTRY3  233, SetInformationFile, 5 
SYSSTUBS_ENTRY4  233, SetInformationFile, 5 
SYSSTUBS_ENTRY5  233, SetInformationFile, 5 
SYSSTUBS_ENTRY6  233, SetInformationFile, 5 
SYSSTUBS_ENTRY7  233, SetInformationFile, 5 
SYSSTUBS_ENTRY8  233, SetInformationFile, 5 
SYSSTUBS_ENTRY1  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY2  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY3  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY4  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY5  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY6  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY7  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY8  234, SetInformationJobObject, 4 
SYSSTUBS_ENTRY1  235, SetInformationKey, 4 
SYSSTUBS_ENTRY2  235, SetInformationKey, 4 
SYSSTUBS_ENTRY3  235, SetInformationKey, 4 
SYSSTUBS_ENTRY4  235, SetInformationKey, 4 
SYSSTUBS_ENTRY5  235, SetInformationKey, 4 
SYSSTUBS_ENTRY6  235, SetInformationKey, 4 
SYSSTUBS_ENTRY7  235, SetInformationKey, 4 
SYSSTUBS_ENTRY8  235, SetInformationKey, 4 
SYSSTUBS_ENTRY1  236, SetInformationObject, 4 
SYSSTUBS_ENTRY2  236, SetInformationObject, 4 
SYSSTUBS_ENTRY3  236, SetInformationObject, 4 
SYSSTUBS_ENTRY4  236, SetInformationObject, 4 
SYSSTUBS_ENTRY5  236, SetInformationObject, 4 
SYSSTUBS_ENTRY6  236, SetInformationObject, 4 
SYSSTUBS_ENTRY7  236, SetInformationObject, 4 
SYSSTUBS_ENTRY8  236, SetInformationObject, 4 
SYSSTUBS_ENTRY1  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY2  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY3  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY4  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY5  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY6  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY7  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY8  237, SetInformationProcess, 4 
SYSSTUBS_ENTRY1  238, SetInformationThread, 4 
SYSSTUBS_ENTRY2  238, SetInformationThread, 4 
SYSSTUBS_ENTRY3  238, SetInformationThread, 4 
SYSSTUBS_ENTRY4  238, SetInformationThread, 4 
SYSSTUBS_ENTRY5  238, SetInformationThread, 4 
SYSSTUBS_ENTRY6  238, SetInformationThread, 4 
SYSSTUBS_ENTRY7  238, SetInformationThread, 4 
SYSSTUBS_ENTRY8  238, SetInformationThread, 4 
SYSSTUBS_ENTRY1  239, SetInformationToken, 4 
SYSSTUBS_ENTRY2  239, SetInformationToken, 4 
SYSSTUBS_ENTRY3  239, SetInformationToken, 4 
SYSSTUBS_ENTRY4  239, SetInformationToken, 4 
SYSSTUBS_ENTRY5  239, SetInformationToken, 4 
SYSSTUBS_ENTRY6  239, SetInformationToken, 4 
SYSSTUBS_ENTRY7  239, SetInformationToken, 4 
SYSSTUBS_ENTRY8  239, SetInformationToken, 4 
SYSSTUBS_ENTRY1  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY2  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY3  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY4  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY5  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY6  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY7  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY8  240, SetIntervalProfile, 2 
SYSSTUBS_ENTRY1  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY2  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY3  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY4  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY5  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY6  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY7  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY8  241, SetIoCompletion, 5 
SYSSTUBS_ENTRY1  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY2  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY3  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY4  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY5  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY6  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY7  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY8  242, SetLdtEntries, 6 
SYSSTUBS_ENTRY1  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY2  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY3  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY4  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY5  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY6  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY7  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY8  243, SetLowEventPair, 1 
SYSSTUBS_ENTRY1  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY2  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY3  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY4  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY5  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY6  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY7  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY8  244, SetLowWaitHighEventPair, 1 
SYSSTUBS_ENTRY1  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY2  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY3  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY4  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY5  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY6  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY7  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY8  245, SetQuotaInformationFile, 4 
SYSSTUBS_ENTRY1  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY2  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY3  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY4  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY5  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY6  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY7  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY8  246, SetSecurityObject, 3 
SYSSTUBS_ENTRY1  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY2  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY3  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY4  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY5  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY6  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY7  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY8  247, SetSystemEnvironmentValue, 2 
SYSSTUBS_ENTRY1  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY2  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY3  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY4  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY5  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY6  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY7  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY8  248, SetSystemEnvironmentValueEx, 5 
SYSSTUBS_ENTRY1  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY2  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY3  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY4  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY5  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY6  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY7  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY8  249, SetSystemInformation, 3 
SYSSTUBS_ENTRY1  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY2  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY3  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY4  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY5  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY6  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY7  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY8  250, SetSystemPowerState, 3 
SYSSTUBS_ENTRY1  251, SetSystemTime, 2 
SYSSTUBS_ENTRY2  251, SetSystemTime, 2 
SYSSTUBS_ENTRY3  251, SetSystemTime, 2 
SYSSTUBS_ENTRY4  251, SetSystemTime, 2 
SYSSTUBS_ENTRY5  251, SetSystemTime, 2 
SYSSTUBS_ENTRY6  251, SetSystemTime, 2 
SYSSTUBS_ENTRY7  251, SetSystemTime, 2 
SYSSTUBS_ENTRY8  251, SetSystemTime, 2 
SYSSTUBS_ENTRY1  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY2  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY3  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY4  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY5  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY6  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY7  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY8  252, SetThreadExecutionState, 2 
SYSSTUBS_ENTRY1  253, SetTimer, 7 
SYSSTUBS_ENTRY2  253, SetTimer, 7 
SYSSTUBS_ENTRY3  253, SetTimer, 7 
SYSSTUBS_ENTRY4  253, SetTimer, 7 
SYSSTUBS_ENTRY5  253, SetTimer, 7 
SYSSTUBS_ENTRY6  253, SetTimer, 7 
SYSSTUBS_ENTRY7  253, SetTimer, 7 
SYSSTUBS_ENTRY8  253, SetTimer, 7 
SYSSTUBS_ENTRY1  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY2  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY3  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY4  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY5  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY6  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY7  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY8  254, SetTimerResolution, 3 
SYSSTUBS_ENTRY1  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY2  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY3  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY4  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY5  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY6  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY7  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY8  255, SetUuidSeed, 1 
SYSSTUBS_ENTRY1  256, SetValueKey, 6 
SYSSTUBS_ENTRY2  256, SetValueKey, 6 
SYSSTUBS_ENTRY3  256, SetValueKey, 6 
SYSSTUBS_ENTRY4  256, SetValueKey, 6 
SYSSTUBS_ENTRY5  256, SetValueKey, 6 
SYSSTUBS_ENTRY6  256, SetValueKey, 6 
SYSSTUBS_ENTRY7  256, SetValueKey, 6 
SYSSTUBS_ENTRY8  256, SetValueKey, 6 
SYSSTUBS_ENTRY1  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY2  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY3  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY4  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY5  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY6  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY7  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY8  257, SetVolumeInformationFile, 5 
SYSSTUBS_ENTRY1  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY2  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY3  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY4  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY5  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY6  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY7  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY8  258, ShutdownSystem, 1 
SYSSTUBS_ENTRY1  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY2  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY3  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY4  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY5  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY6  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY7  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY8  259, SignalAndWaitForSingleObject, 4 
SYSSTUBS_ENTRY1  260, StartProfile, 1 
SYSSTUBS_ENTRY2  260, StartProfile, 1 
SYSSTUBS_ENTRY3  260, StartProfile, 1 
SYSSTUBS_ENTRY4  260, StartProfile, 1 
SYSSTUBS_ENTRY5  260, StartProfile, 1 
SYSSTUBS_ENTRY6  260, StartProfile, 1 
SYSSTUBS_ENTRY7  260, StartProfile, 1 
SYSSTUBS_ENTRY8  260, StartProfile, 1 
SYSSTUBS_ENTRY1  261, StopProfile, 1 
SYSSTUBS_ENTRY2  261, StopProfile, 1 
SYSSTUBS_ENTRY3  261, StopProfile, 1 
SYSSTUBS_ENTRY4  261, StopProfile, 1 
SYSSTUBS_ENTRY5  261, StopProfile, 1 
SYSSTUBS_ENTRY6  261, StopProfile, 1 
SYSSTUBS_ENTRY7  261, StopProfile, 1 
SYSSTUBS_ENTRY8  261, StopProfile, 1 
SYSSTUBS_ENTRY1  262, SuspendProcess, 1 
SYSSTUBS_ENTRY2  262, SuspendProcess, 1 
SYSSTUBS_ENTRY3  262, SuspendProcess, 1 
SYSSTUBS_ENTRY4  262, SuspendProcess, 1 
SYSSTUBS_ENTRY5  262, SuspendProcess, 1 
SYSSTUBS_ENTRY6  262, SuspendProcess, 1 
SYSSTUBS_ENTRY7  262, SuspendProcess, 1 
SYSSTUBS_ENTRY8  262, SuspendProcess, 1 
SYSSTUBS_ENTRY1  263, SuspendThread, 2 
SYSSTUBS_ENTRY2  263, SuspendThread, 2 
SYSSTUBS_ENTRY3  263, SuspendThread, 2 
SYSSTUBS_ENTRY4  263, SuspendThread, 2 
SYSSTUBS_ENTRY5  263, SuspendThread, 2 
SYSSTUBS_ENTRY6  263, SuspendThread, 2 
SYSSTUBS_ENTRY7  263, SuspendThread, 2 
SYSSTUBS_ENTRY8  263, SuspendThread, 2 
SYSSTUBS_ENTRY1  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY2  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY3  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY4  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY5  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY6  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY7  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY8  264, SystemDebugControl, 6 
SYSSTUBS_ENTRY1  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY2  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY3  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY4  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY5  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY6  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY7  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY8  265, TerminateJobObject, 2 
SYSSTUBS_ENTRY1  266, TerminateProcess, 2 
SYSSTUBS_ENTRY2  266, TerminateProcess, 2 
SYSSTUBS_ENTRY3  266, TerminateProcess, 2 
SYSSTUBS_ENTRY4  266, TerminateProcess, 2 
SYSSTUBS_ENTRY5  266, TerminateProcess, 2 
SYSSTUBS_ENTRY6  266, TerminateProcess, 2 
SYSSTUBS_ENTRY7  266, TerminateProcess, 2 
SYSSTUBS_ENTRY8  266, TerminateProcess, 2 
SYSSTUBS_ENTRY1  267, TerminateThread, 2 
SYSSTUBS_ENTRY2  267, TerminateThread, 2 
SYSSTUBS_ENTRY3  267, TerminateThread, 2 
SYSSTUBS_ENTRY4  267, TerminateThread, 2 
SYSSTUBS_ENTRY5  267, TerminateThread, 2 
SYSSTUBS_ENTRY6  267, TerminateThread, 2 
SYSSTUBS_ENTRY7  267, TerminateThread, 2 
SYSSTUBS_ENTRY8  267, TerminateThread, 2 
SYSSTUBS_ENTRY1  268, TestAlert, 0 
SYSSTUBS_ENTRY2  268, TestAlert, 0 
SYSSTUBS_ENTRY3  268, TestAlert, 0 
SYSSTUBS_ENTRY4  268, TestAlert, 0 
SYSSTUBS_ENTRY5  268, TestAlert, 0 
SYSSTUBS_ENTRY6  268, TestAlert, 0 
SYSSTUBS_ENTRY7  268, TestAlert, 0 
SYSSTUBS_ENTRY8  268, TestAlert, 0 
SYSSTUBS_ENTRY1  269, TraceEvent, 4 
SYSSTUBS_ENTRY2  269, TraceEvent, 4 
SYSSTUBS_ENTRY3  269, TraceEvent, 4 
SYSSTUBS_ENTRY4  269, TraceEvent, 4 
SYSSTUBS_ENTRY5  269, TraceEvent, 4 
SYSSTUBS_ENTRY6  269, TraceEvent, 4 
SYSSTUBS_ENTRY7  269, TraceEvent, 4 
SYSSTUBS_ENTRY8  269, TraceEvent, 4 
SYSSTUBS_ENTRY1  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY2  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY3  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY4  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY5  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY6  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY7  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY8  270, TranslateFilePath, 4 
SYSSTUBS_ENTRY1  271, UnloadDriver, 1 
SYSSTUBS_ENTRY2  271, UnloadDriver, 1 
SYSSTUBS_ENTRY3  271, UnloadDriver, 1 
SYSSTUBS_ENTRY4  271, UnloadDriver, 1 
SYSSTUBS_ENTRY5  271, UnloadDriver, 1 
SYSSTUBS_ENTRY6  271, UnloadDriver, 1 
SYSSTUBS_ENTRY7  271, UnloadDriver, 1 
SYSSTUBS_ENTRY8  271, UnloadDriver, 1 
SYSSTUBS_ENTRY1  272, UnloadKey, 1 
SYSSTUBS_ENTRY2  272, UnloadKey, 1 
SYSSTUBS_ENTRY3  272, UnloadKey, 1 
SYSSTUBS_ENTRY4  272, UnloadKey, 1 
SYSSTUBS_ENTRY5  272, UnloadKey, 1 
SYSSTUBS_ENTRY6  272, UnloadKey, 1 
SYSSTUBS_ENTRY7  272, UnloadKey, 1 
SYSSTUBS_ENTRY8  272, UnloadKey, 1 
SYSSTUBS_ENTRY1  273, UnloadKey2, 2 
SYSSTUBS_ENTRY2  273, UnloadKey2, 2 
SYSSTUBS_ENTRY3  273, UnloadKey2, 2 
SYSSTUBS_ENTRY4  273, UnloadKey2, 2 
SYSSTUBS_ENTRY5  273, UnloadKey2, 2 
SYSSTUBS_ENTRY6  273, UnloadKey2, 2 
SYSSTUBS_ENTRY7  273, UnloadKey2, 2 
SYSSTUBS_ENTRY8  273, UnloadKey2, 2 
SYSSTUBS_ENTRY1  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY2  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY3  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY4  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY5  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY6  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY7  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY8  274, UnloadKeyEx, 2 
SYSSTUBS_ENTRY1  275, UnlockFile, 5 
SYSSTUBS_ENTRY2  275, UnlockFile, 5 
SYSSTUBS_ENTRY3  275, UnlockFile, 5 
SYSSTUBS_ENTRY4  275, UnlockFile, 5 
SYSSTUBS_ENTRY5  275, UnlockFile, 5 
SYSSTUBS_ENTRY6  275, UnlockFile, 5 
SYSSTUBS_ENTRY7  275, UnlockFile, 5 
SYSSTUBS_ENTRY8  275, UnlockFile, 5 
SYSSTUBS_ENTRY1  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY2  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY3  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY4  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY5  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY6  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY7  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY8  276, UnlockVirtualMemory, 4 
SYSSTUBS_ENTRY1  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY2  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY3  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY4  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY5  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY6  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY7  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY8  277, UnmapViewOfSection, 2 
SYSSTUBS_ENTRY1  278, VdmControl, 2 
SYSSTUBS_ENTRY2  278, VdmControl, 2 
SYSSTUBS_ENTRY3  278, VdmControl, 2 
SYSSTUBS_ENTRY4  278, VdmControl, 2 
SYSSTUBS_ENTRY5  278, VdmControl, 2 
SYSSTUBS_ENTRY6  278, VdmControl, 2 
SYSSTUBS_ENTRY7  278, VdmControl, 2 
SYSSTUBS_ENTRY8  278, VdmControl, 2 
SYSSTUBS_ENTRY1  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY2  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY3  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY4  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY5  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY6  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY7  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY8  279, WaitForDebugEvent, 4 
SYSSTUBS_ENTRY1  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY2  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY3  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY4  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY5  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY6  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY7  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY8  280, WaitForMultipleObjects, 5 
SYSSTUBS_ENTRY1  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY2  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY3  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY4  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY5  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY6  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY7  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY8  281, WaitForSingleObject, 3 
SYSSTUBS_ENTRY1  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY2  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY3  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY4  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY5  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY6  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY7  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY8  282, WaitHighEventPair, 1 
SYSSTUBS_ENTRY1  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY2  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY3  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY4  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY5  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY6  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY7  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY8  283, WaitLowEventPair, 1 
SYSSTUBS_ENTRY1  284, WriteFile, 9 
SYSSTUBS_ENTRY2  284, WriteFile, 9 
SYSSTUBS_ENTRY3  284, WriteFile, 9 
SYSSTUBS_ENTRY4  284, WriteFile, 9 
SYSSTUBS_ENTRY5  284, WriteFile, 9 
SYSSTUBS_ENTRY6  284, WriteFile, 9 
SYSSTUBS_ENTRY7  284, WriteFile, 9 
SYSSTUBS_ENTRY8  284, WriteFile, 9 
SYSSTUBS_ENTRY1  285, WriteFileGather, 9 
SYSSTUBS_ENTRY2  285, WriteFileGather, 9 
SYSSTUBS_ENTRY3  285, WriteFileGather, 9 
SYSSTUBS_ENTRY4  285, WriteFileGather, 9 
SYSSTUBS_ENTRY5  285, WriteFileGather, 9 
SYSSTUBS_ENTRY6  285, WriteFileGather, 9 
SYSSTUBS_ENTRY7  285, WriteFileGather, 9 
SYSSTUBS_ENTRY8  285, WriteFileGather, 9 
SYSSTUBS_ENTRY1  286, WriteRequestData, 6 
SYSSTUBS_ENTRY2  286, WriteRequestData, 6 
SYSSTUBS_ENTRY3  286, WriteRequestData, 6 
SYSSTUBS_ENTRY4  286, WriteRequestData, 6 
SYSSTUBS_ENTRY5  286, WriteRequestData, 6 
SYSSTUBS_ENTRY6  286, WriteRequestData, 6 
SYSSTUBS_ENTRY7  286, WriteRequestData, 6 
SYSSTUBS_ENTRY8  286, WriteRequestData, 6 
SYSSTUBS_ENTRY1  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY2  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY3  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY4  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY5  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY6  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY7  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY8  287, WriteVirtualMemory, 5 
SYSSTUBS_ENTRY1  288, YieldExecution, 0 
SYSSTUBS_ENTRY2  288, YieldExecution, 0 
SYSSTUBS_ENTRY3  288, YieldExecution, 0 
SYSSTUBS_ENTRY4  288, YieldExecution, 0 
SYSSTUBS_ENTRY5  288, YieldExecution, 0 
SYSSTUBS_ENTRY6  288, YieldExecution, 0 
SYSSTUBS_ENTRY7  288, YieldExecution, 0 
SYSSTUBS_ENTRY8  288, YieldExecution, 0 
SYSSTUBS_ENTRY1  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY2  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY3  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY4  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY5  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY6  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY7  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY8  289, CreateKeyedEvent, 4 
SYSSTUBS_ENTRY1  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY2  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY3  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY4  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY5  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY6  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY7  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY8  290, OpenKeyedEvent, 3 
SYSSTUBS_ENTRY1  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY2  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY3  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY4  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY5  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY6  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY7  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY8  291, ReleaseKeyedEvent, 4 
SYSSTUBS_ENTRY1  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY2  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY3  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY4  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY5  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY6  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY7  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY8  292, WaitForKeyedEvent, 4 
SYSSTUBS_ENTRY1  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY2  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY3  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY4  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY5  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY6  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY7  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY8  293, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY1  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY2  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY3  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY4  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY5  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY6  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY7  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY8  294, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY1  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY2  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY3  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY4  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY5  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY6  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY7  295, WaitForMultipleObjects32, 5 
SYSSTUBS_ENTRY8  295, WaitForMultipleObjects32, 5 

STUBS_END
